(
	-- Normal Bump
	struct AMGData
	(
		fn GetUUID mtl context =
		(	
			"637b9cdd-2908-454a-a8c9-ff9c98970637"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			if mtl.normal_map != undefined and mtl.map1on do (
				append res #("normal_map", mtl.normal_map, "result", 0) -- reset context to zero - no longer bump evaluation!	

				local mapChannel = 1

				try (
					mapChannel = mtl.normal_map.coords.mapChannel
				)
				catch (
					mapChannel = 1
				)

				-- Environment mode cannot use varying attributes
				if (context != 2) do
				(
					append res #("utangent", undefined, "u_tangent_" + (mapChannel as String))
					append res #("vtangent", undefined, "v_tangent_" + (mapChannel as String))
				)
			)

			if mtl.bump_map != undefined and mtl.map2on do (
				append res #("additional_bump", mtl.bump_map, "normalPerturb", 1) 
			)

 			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			append res #("amount", mtl.mult_spin)
			append res #("normal_map", (point3 0.5 0.5 0.0))

			append res #("additional_amount", mtl.bump_spin)

			append res #("swap_rg", mtl.swap_rg)
			append res #("flip_r", mtl.flipred)
			append res #("flip_g", mtl.flipgreen)

 			res
		)
	)
	AMGData()
)